#!/bin/bash
# export imagenet_path=<path/to/imagenet> (default: ~/data/ImageNet)
# export batch_size=...                   (default: 10)
# export num_workers=...                  (default: 10)
# NB: Replace `python` with `accelerate launch` for distributed run

accelerate launch main.py ESRGAN classical_sr-4                                 # ESRGAN    (SISRx4)
accelerate launch main.py SwinIR classical_sr-4                                 # SwinIR    (SISRx4)
accelerate launch main.py accelerate launch.py SwinIR jpeg_car-10                   # SwinIR    (JPEGq10)
accelerate launch main.py Restormer gaussian_color_denoising_sigma50            # Restormer (AWGNs50)
accelerate launch precomputed_results.py DDRM classical_sr_4_dn_25 imagenet-1k  # DDRM      (SISRx4 + AWGNs25)

# Swin2SR   (SISRx4 + JPEGq10)
accelerate launch main.py Swin2SR compressed_sr-4 \
 --natural_image_set ["compressed_sr_swin2sr"] \
 --degraded_set ["compressed_sr_swin2sr"] \
 --quantitative_set ["compressed_sr_swin2sr"] \
 --qualitative_set ["compressed_sr_swin2sr"]

# NLM consumes significant memory footprint so we use a batch-size of 1
export batch_size=1
export num_workers=0
accelerate launch main.py NLM color_dn-50                                       # NLM       (AWGNs50)
