function subgrad = objective_subgradient_batch(Ac, idmalec, idfemalec, nummalec, numfemalec, w, Sc_w)

    tensor_Sc_w_malec = repmat(Sc_w, 1, 1, length(idmalec));
    tensor_Sc_w_femalec = repmat(Sc_w, 1, 1, length(idfemalec));
    tensor_Acs_malec = repmat(Ac(idmalec,:)*w, 1, 1, size(Sc_w,1)); 
    tensor_Acs_malec = permute(tensor_Acs_malec, [3 2 1]);
    tensor_Acs_femalec = repmat(Ac(idfemalec,:)*w, 1, 1, size(Sc_w,1)); 
    tensor_Acs_femalec = permute(tensor_Acs_femalec, [3 2 1]);
    
    % compute mean_male = mean( sigmoid ( A_male * w - S_w ) )
    sigmoid_mean_male = mean( 1 ./ ( 1 + exp( tensor_Sc_w_malec-tensor_Acs_malec ) ) ,3);
    % compute mean_female = mean( sigmoid ( A_female * w - S_w ) )
    sigmoid_mean_female = mean( 1 ./ ( 1 + exp( tensor_Sc_w_femalec - tensor_Acs_femalec ) ) ,3);
    % get the array of objective candidates abs( mean_male - mean_female ) 
    % then obtain the index of the largest one 
    [~, index] = max( abs( sigmoid_mean_male - sigmoid_mean_female ) );

    % compute the first part, sgn value, in the subgradient F'(w)
    sgn = sign( sigmoid_mean_male(sub2ind(size(sigmoid_mean_male), index, 1:size(sigmoid_mean_male,2))) ...
        - sigmoid_mean_female(sub2ind(size(sigmoid_mean_female), index, 1:size(sigmoid_mean_female,2))) );

    % based on this s, construct the second part in the subgradient F'(w)
    % compute derivative_male = Ac_male^T * ( sigmoid ./ (1 - sigmoid ) ) / nc_M
    Sc_w_index = Sc_w(sub2ind(size(Sc_w), index, 1:size(Sc_w,2)));
    sigmoid_male_s = 1 ./ ( 1 + exp( Sc_w_index - Ac(idmalec,:)*w ) );
    subgrad_male = Ac(idmalec,:)' * ( sigmoid_male_s .* (1 - sigmoid_male_s) ) / nummalec;
    % compute derivative_female = Ac_female^T * ( sigmoid ./ (1 - sigmoid ) ) ) / nc_F
    sigmoid_female_s = 1 ./ ( 1 + exp( Sc_w_index - Ac(idfemalec,:)*w ) );
    subgrad_female = Ac(idfemalec,:)' * ( sigmoid_female_s .* (1 - sigmoid_female_s) ) / numfemalec;

    % get the value of subgradient F'(w)
    subgrad = sgn.* ( subgrad_male - subgrad_female );
end