#!/bin/bash

pwd
source ../../zsl/bin/activate

for dataset_dir in '<PATH_TO_DATA>' ; do # This is the path to the directory containing all tasks
for vis_encoder in 'ViT-B/32'; do # Set the visual encoder to use ('ViT-B/32', 'ViT-L/14')
for split_seed in 500; do #  When running TRZSL, set the name of the split: 500, 0, 200
for dataset_name in RESICS45; do # Name of the task
for model in textual_prompt visual_prompt multimodal_prompt; do # CoOp, VPT, and UPL baselines
# for model in textual_fpl visual_fpl multimodal_fpl; do # FPL 
# for model in iterative_textual_fpl iterative_visual_fpl iterative_multimodal_fpl; do # IFPL 
# for model in grip_textual grip_visual grip_multimodal; do # GRIP 
for optim_seed in 1 2 3 4 5; do # Insert the list of seed for the optimization
    
    export OPTIM_SEED="$optim_seed"
    export VIS_ENCODER="$vis_encoder"
    export DATASET_NAME="$dataset_name"
    export SPLIT_SEED="$split_seed"
    export MODEL="$model"
    export DATASET_DIR="$dataset_dir"

    accelerate launch --config_file ./accelerate_config.yml ./run_main_ssl.py \
                    --model_config ${model}_config.yml --learning_paradigm ssl
done
done
done
done
done
done