"""
Make the evaluation tasks for environments.
"""
import os
import pickle as pkl
import random

import gym
import numpy as np

import rlkit.envs


# Constants.
# ENV_NAMES = ['msd', 'dmsd']
ENV_NAMES = ['bnrot']
ENV_TYPES = {
    'msd': ['fixed', 'small', 'med', 'large'],
    'dmsd': ['fixed', 'small', 'med', 'large'],
    'nav': ['sim', 'real'],
    'unav': ['sim', 'real'],
    'fusion': ['sim', 'real'],
    'bnrot': ['sim', 'real'],
}
EVAL_TYPES = ['tr', 'val', 'te']
SAVE_DIR = 'rlkit/envs/eval_settings'
NUM_SETTINGS = 100
SEED = 0
random.seed(SEED)
np.random.seed(SEED)
# Create settings.
for en in ENV_NAMES:
    for et in ENV_TYPES[en]:
        if (en == 'fusion' or en == 'bnrot') and et == 'real':
            import fusion_control.envs
        env = gym.make(f'{en}-{et}-xtf-v0')
        for etype in EVAL_TYPES:
            if etype == 'te' and en == 'fusion' and et == 'real':
                with open(os.path.join(SAVE_DIR, f'{en}-{et}-te.pkl'), 'wb') as f:
                    pkl.dump({
                        'start': env.sample_starts(NUM_SETTINGS, testing=True),
                        'task': env.sample_tasks(NUM_SETTINGS, testing=True),
                        'targets': env.sample_targets(NUM_SETTINGS),
                    }, f)
            else:
                with open(os.path.join(SAVE_DIR, f'{en}-{et}-{etype}.pkl'), 'wb') as f:
                    pkl.dump({
                        'start': env.sample_starts(NUM_SETTINGS),
                        'task': env.sample_tasks(NUM_SETTINGS),
                        'targets': env.sample_targets(NUM_SETTINGS),
                    }, f)
