## Installation

This codebase was developed using python 3.9.16, and it is built off of the
[rlkit](https://github.com/rail-berkeley/rlkit). In order to set up the code
run...

```
pip install -e .
```

## Training

In order to train run:

```
python scripts/train.py\
    name=test_run \
    rl=tracking_gpide_sac \
    env=msd-small \
    seed=0
```

Optionally, you can add `cuda_device=<cuda_device_number>` if you want to train
with a GPU. All options for `rl` and `env` can be found in /cfgs/rl and /cfgs/env.
The rl config specifies which RL baselines to use, and the env config specifies which
task to perform. When selecting a tracking environment, use an rl configuration
with the prefix "tracking" and with the prefix "pyb" otherwise.

The results can be found in the logs directory. Among other things, statsitics are
written to tensorboard for viewing.

## Plotting and Table Scripts

Tracking Plots:

```
python scripts/plotting/msd_grid.py \
    --data_path <parent_dir_to_experiments> \
    --env_type <type_of_env e.g. msd,dmsd,nav...> \
    --var_types <var_types e.v. fixed,small,large> \
```

Tracking Tables:

```
python scripts/table/tracking_table.py \
    --data_path <parent_dir_to_experiments> \
    --env_types <types_of_env e.g. msd,dmsd,nav...> \
    --var_types <var_types e.v. fixed,small,large> \
```

PyBullet Plots:

```
python scripts/plotting/pyb_grid.py --data_path <parent_dir_to_experiments>
```

PyBullet Table:

```
python scripts/table/tracking_table.py \
    --data_path <parent_dir_to_experiments> \
```

Note that for all PyBullet baselines, traces must be downloaded from

https://github.com/twni2016/pomdp-baselines

In particular, the .csv files should be put into a directory named `pomdp` at the
top level of this directory.
