# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from lightly.openapi_generated.swagger_client.configuration import Configuration


class SelectionConfigEntryInput(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'SelectionInputType',
        'task': 'str',
        'score': 'ActiveLearningScoreType',
        'key': 'str',
        'name': 'SelectionInputPredictionsName',
        'dataset_id': 'MongoObjectID',
        'tag_name': 'TagName'
    }

    attribute_map = {
        'type': 'type',
        'task': 'task',
        'score': 'score',
        'key': 'key',
        'name': 'name',
        'dataset_id': 'datasetId',
        'tag_name': 'tagName'
    }

    def __init__(self, type=None, task=None, score=None, key=None, name=None, dataset_id=None, tag_name=None, _configuration=None):  # noqa: E501
        """SelectionConfigEntryInput - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._type = None
        self._task = None
        self._score = None
        self._key = None
        self._name = None
        self._dataset_id = None
        self._tag_name = None
        self.discriminator = None

        self.type = type
        if task is not None:
            self.task = task
        if score is not None:
            self.score = score
        if key is not None:
            self.key = key
        if name is not None:
            self.name = name
        if dataset_id is not None:
            self.dataset_id = dataset_id
        if tag_name is not None:
            self.tag_name = tag_name

    @property
    def type(self):
        """Gets the type of this SelectionConfigEntryInput.  # noqa: E501


        :return: The type of this SelectionConfigEntryInput.  # noqa: E501
        :rtype: SelectionInputType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this SelectionConfigEntryInput.


        :param type: The type of this SelectionConfigEntryInput.  # noqa: E501
        :type: SelectionInputType
        """
        if self._configuration.client_side_validation and type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def task(self):
        """Gets the task of this SelectionConfigEntryInput.  # noqa: E501


        :return: The task of this SelectionConfigEntryInput.  # noqa: E501
        :rtype: str
        """
        return self._task

    @task.setter
    def task(self, task):
        """Sets the task of this SelectionConfigEntryInput.


        :param task: The task of this SelectionConfigEntryInput.  # noqa: E501
        :type: str
        """

        self._task = task

    @property
    def score(self):
        """Gets the score of this SelectionConfigEntryInput.  # noqa: E501


        :return: The score of this SelectionConfigEntryInput.  # noqa: E501
        :rtype: ActiveLearningScoreType
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this SelectionConfigEntryInput.


        :param score: The score of this SelectionConfigEntryInput.  # noqa: E501
        :type: ActiveLearningScoreType
        """

        self._score = score

    @property
    def key(self):
        """Gets the key of this SelectionConfigEntryInput.  # noqa: E501


        :return: The key of this SelectionConfigEntryInput.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this SelectionConfigEntryInput.


        :param key: The key of this SelectionConfigEntryInput.  # noqa: E501
        :type: str
        """

        self._key = key

    @property
    def name(self):
        """Gets the name of this SelectionConfigEntryInput.  # noqa: E501


        :return: The name of this SelectionConfigEntryInput.  # noqa: E501
        :rtype: SelectionInputPredictionsName
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SelectionConfigEntryInput.


        :param name: The name of this SelectionConfigEntryInput.  # noqa: E501
        :type: SelectionInputPredictionsName
        """

        self._name = name

    @property
    def dataset_id(self):
        """Gets the dataset_id of this SelectionConfigEntryInput.  # noqa: E501


        :return: The dataset_id of this SelectionConfigEntryInput.  # noqa: E501
        :rtype: MongoObjectID
        """
        return self._dataset_id

    @dataset_id.setter
    def dataset_id(self, dataset_id):
        """Sets the dataset_id of this SelectionConfigEntryInput.


        :param dataset_id: The dataset_id of this SelectionConfigEntryInput.  # noqa: E501
        :type: MongoObjectID
        """

        self._dataset_id = dataset_id

    @property
    def tag_name(self):
        """Gets the tag_name of this SelectionConfigEntryInput.  # noqa: E501


        :return: The tag_name of this SelectionConfigEntryInput.  # noqa: E501
        :rtype: TagName
        """
        return self._tag_name

    @tag_name.setter
    def tag_name(self, tag_name):
        """Sets the tag_name of this SelectionConfigEntryInput.


        :param tag_name: The tag_name of this SelectionConfigEntryInput.  # noqa: E501
        :type: TagName
        """

        self._tag_name = tag_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SelectionConfigEntryInput, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SelectionConfigEntryInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SelectionConfigEntryInput):
            return True

        return self.to_dict() != other.to_dict()
