import argparse
from classification.get_model_predictions import run_model_predictions
from classification.train_classification import run_classification
from offline_evaluation.offline_NCC import run_ncc_evaluation
from offline_linear import run_linear_evaluation
import os


def run_eval(task, checkpoint_folder, output_folder, rand_targets_folder=None):
    new_output_folder = os.path.join(output_folder, task)
    print(f"task:{task}")
    if task == "linear":
        print("inside the clause")
        run_linear_evaluation(checkpoint_folder, new_output_folder,
                              rand_targets_folder=rand_targets_folder)

    elif task == "ncc":
        run_ncc_evaluation(checkpoint_folder, new_output_folder,
                              rand_targets_folder=rand_targets_folder)

    elif task == "train_supervised_classifier":
        run_classification(new_output_folder)

    elif task == 'get_classifier_predictions':
        run_model_predictions(checkpoint_folder, new_output_folder)

    else:
        print(f"Not implemented:{task}")


def run_main():
    eval_types = ['linear', 'ncc', 'train_supervised_classifier', 'get_classifier_predictions']
    parser = argparse.ArgumentParser()
    parser.add_argument('--task', type=str, help='task type', required=True, choices=eval_types)
    parser.add_argument('--checkpoint_folder', type=str, required=True)
    parser.add_argument('--output_folder', type=str, required=True)
    parser.add_argument('--rand_targets_folder', type=str, required=True)
    args = parser.parse_args()

    run_eval(args.task, args.checkpoint_folder, args.output_folder, args.rand_targets_folder)


if __name__ == '__main__':
    run_main()
