from setuptools import setup, find_packages


def parse_requirements(filename):
    """ load requirements from a pip requirements file """
    line_iter = (line.strip() for line in open(filename))
    return [line for line in line_iter if line and not line.startswith("#")]


install_req = parse_requirements("requirements.txt")

setup(name='actirank',
      version='0.0.0',
      description='Python implementation of active ranking algorithm',
      url='https://github.com/vl123456/active_ranking',
      author='Vincent LAURENT',
      author_email='vlaurent@eurobios.com',
      install_requires=install_req,
      packages=find_packages(),
      include_package_data=True,
      zip_safe=False)
