"""SAMPLING ONLY."""

import torch

from .dpm_solver_v3 import NoiseScheduleVP, model_wrapper, DPM_Solver_v3
import os


class DPMSolverv3Sampler:
    def __init__(self, ckp_path, model, steps, guidance_scale, **kwargs):
        super().__init__()
        self.model = model
        to_torch = lambda x: x.clone().detach().to(torch.float32).to(model.device)
        self.alphas_cumprod = to_torch(model.alphas_cumprod)
        self.device = self.model.betas.device
        self.guidance_scale = guidance_scale

        self.ns = NoiseScheduleVP("discrete", alphas_cumprod=self.alphas_cumprod)

        # choose statistics
        stats_base = os.path.join("statistics", ckp_path.split("/")[-1].split(".")[0])
        stats_dir = None
        max_steps, max_samples = -1, -1
        for folder in os.listdir(stats_base):
            lst = folder.split("_")
            num_steps, num_samples = int(lst[-4]), int(lst[-3]) * int(lst[-2]) * int(lst[-1])
            if num_steps > max_steps or (num_steps == max_steps and num_samples > max_samples):
                max_steps, max_samples = num_steps, num_samples
                stats_dir = os.path.join(stats_base, folder)

        assert stats_dir is not None, f"No statistics file found in {stats_base}."
        print("Use statistics", stats_dir)
        self.dpm_solver_v3 = DPM_Solver_v3(
            statistics_dir=stats_dir,
            statistics_steps=max_steps,
            noise_schedule=self.ns,
            steps=steps,
            guidance_scale=guidance_scale,
            t_start=None,
            t_end=None,
            skip_type="time_uniform",
            degenerated=False,
            device=self.device,
        )

    @torch.no_grad()
    def sample(
        self,
        batch_size,
        shape,
        conditioning=None,
        x_T=None,
        unconditional_conditioning=None,
        # this has to come in the same format as the conditioning, # e.g. as encoded tokens, ...
        **kwargs,
    ):
        if conditioning is not None:
            if isinstance(conditioning, dict):
                cbs = conditioning[list(conditioning.keys())[0]].shape[0]
                if cbs != batch_size:
                    print(f"Warning: Got {cbs} conditionings but batch-size is {batch_size}")
            else:
                if conditioning.shape[0] != batch_size:
                    print(f"Warning: Got {conditioning.shape[0]} conditionings but batch-size is {batch_size}")

        # sampling
        C, H, W = shape
        size = (batch_size, C, H, W)

        if x_T is None:
            img = torch.randn(size, device=self.device)
        else:
            img = x_T

        if conditioning is None:
            model_fn = model_wrapper(
                lambda x, t, c: self.model.apply_model(x, t, c),
                self.ns,
                model_type="noise",
                guidance_type="uncond",
            )
            ORDER = 3
        else:
            model_fn = model_wrapper(
                lambda x, t, c: self.model.apply_model(x, t, c),
                self.ns,
                model_type="noise",
                guidance_type="classifier-free",
                condition=conditioning,
                unconditional_condition=unconditional_conditioning,
                guidance_scale=self.guidance_scale,
            )
            ORDER = 2

        x = self.dpm_solver_v3.sample(
            img, model_fn, order=ORDER, p_pseudo=False, use_corrector=True, c_pseudo=False, lower_order_final=True, trick=False
        )

        return x.to(self.device), None