import random


def gen_input(n: int, q: int) -> str:
    permutation = list(range(1, n + 1))
    random.shuffle(permutation)
    queries = []
    for _ in range(q):
        t = random.randint(1, 2)
        if t == 1:
            (x, y) = random.sample(range(1, n + 1), 2)
            queries.append(f'{t} {x} {y}')
        else:
            i = random.randint(1, n)
            k = random.randint(1, n)
            queries.append(f'{t} {i} {k}')
    permutation_str = ' '.join((str(x) for x in permutation))
    queries_str = '\n'.join(queries)
    return f'{n} {q}\n{permutation_str}\n{queries_str}\n'

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        n = random.randint(5, 10)
        q = random.randint(5, 10)
        inputs.append(gen_input(n, q))
    return inputs
