# TEST_RESULT: False
from itertools import permutations, combinations
from math import ceil, floor
from typing import List, Tuple


def generate_schedule(n: int, m: int, k: int) -> List[List[List[int]]]:
    players = [i + 1 for i in range(n)]
    possible_people_per_table = [ceil(n / m), floor(n / m)]
    people_per_table_combinations = list(combinations(possible_people_per_table, m))
    all_schedules = []
    for people_per_table in people_per_table_combinations:
        for player_permutation in permutations(players):
            schedule = []
            player_index = 0
            for game in range(k):
                game_schedule = []
                for people in people_per_table:
                    table = player_permutation[player_index:player_index + people]
                    game_schedule.append(table)
                    player_index += people
                schedule.append(game_schedule)
            all_schedules.append(schedule)
    valid_schedules = []
    for schedule in all_schedules:
        is_valid = True
        bi = [0] * n
        for game_schedule in schedule:
            for table in game_schedule:
                if len(table) == ceil(n / m):
                    for player in table:
                        bi[player - 1] += 1
        for i in range(n):
            for j in range(i + 1, n):
                if abs(bi[i] - bi[j]) > 1:
                    is_valid = False
                    break
            if not is_valid:
                break
        if is_valid:
            valid_schedules.append(schedule)
    return valid_schedules

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    test_cases = [tuple(map(int, line.split())) for line in lines[1:]]
    result = []
    for (n, m, k) in test_cases:
        schedules = generate_schedule_optimized(n, m, k)
        output = []
        for game_schedule in schedules:
            for table in game_schedule:
                output.append(f"{len(table)} {' '.join(map(str, table))}")
        result.append('\n'.join(output))
    return '\n\n'.join(result)

def generate_schedule_optimized(n: int, m: int, k: int) -> List[List[List[int]]]:
    max_people = ceil(n / m)
    min_people = floor(n / m)
    remaining = n % m
    schedule = [[] for _ in range(k)]
    for game in range(k):
        for i in range(n):
            table = (i + game) % m
            schedule[game].append((table + 1, i + 1))
    for game in range(k):
        schedule[game].sort()
    result = []
    for game in range(k):
        game_schedule = []
        table_players = []
        for (i, (table, player)) in enumerate(schedule[game]):
            table_players.append(player)
            if (i + 1) % max_people == 0 or i + 1 == n:
                game_schedule.append(table_players)
                table_players = []
        result.append(game_schedule)
    return result
