import random


def gen_input(max_t=10, max_mn=100, max_p=1000):
    t = random.randint(1, max_t)
    input_str = str(t) + '\n'
    for _ in range(t):
        m = random.randint(2, max_mn)
        n = random.randint(2, max_mn)
        input_str += '\n' + str(m) + ' ' + str(n) + '\n'
        for _ in range(m):
            p = [str(random.randint(1, max_p)) for _ in range(n)]
            input_str += ' '.join(p) + '\n'
    return input_str

def batch_gen_inputs(batch_size,):
    max_t = 10
    max_mn = 100
    max_p = 1000
    total_nm = 0
    inputs = []
    for _ in range(batch_size):
        max_mn = min(max_mn, (10 ** 5 - total_nm) // max_t)
        input_str = gen_input(max_t, max_mn, max_p)
        inputs.append(input_str)
        for line in input_str.split('\n')[1:]:
            if line:
                if len(line.split()) == 2:
                    (m, n) = map(int, line.split())
                    total_nm += m * n
    return inputs
