import random


def gen_input(t: int, n_min: int, n_max: int, a_min: int, a_max: int) -> str:
    """
    Generates a single test input string for the problem.

    Parameters:
    - t: the number of test cases
    - n_min: the minimum possible length of array `a`
    - n_max: the maximum possible length of array `a`
    - a_min: the minimum possible value of an element in array `a`
    - a_max: the maximum possible value of an element in array `a`

    Returns:
    - A string representing the test input.
    """
    test_cases = []
    for _ in range(t):
        n = random.randint(n_min, n_max)
        a = [random.randint(a_min, a_max - 1) for _ in range(n)]
        test_cases.append(f"{n}\n{' '.join(map(str, a))}")
    input_string = f'{t}\n' + '\n'.join(test_cases)
    return input_string

def batch_gen_inputs(batch_size,) -> list[str]:
    """
    Generates multiple test input strings for the problem by calling `gen_input`.

    Returns:
    - A list of strings, each representing a test input.
    """
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(t=random.randint(1, 3), n_min=1, n_max=5, a_min=0, a_max=32))
    return inputs
