import random

def gen_input(max_coord=10 ** 9, max_width_height=10 ** 5):
    bl_x = random.randint(2, max_coord - max_width_height)
    bl_y = random.randint(2, max_coord - max_width_height)
    width = random.randint(1, max_coord - bl_x)
    height = random.randint(1, max_coord - bl_y)
    tr_x = bl_x + width - 1
    tr_y = bl_y + height - 1
    x = random.randint(1, max_coord)
    y = random.randint(1, max_coord)
    while bl_x <= x <= tr_x and bl_y <= y <= tr_y:
        x = random.randint(1, max_coord)
        y = random.randint(1, max_coord)
    dist_bl = abs(x - bl_x) + abs(y - bl_y)
    dist_br = abs(x - (bl_x + width - 1)) + abs(y - bl_y)
    dist_tl = abs(x - bl_x) + abs(y - (bl_y + height - 1))
    dist_tr = abs(x - (bl_x + width - 1)) + abs(y - (bl_y + height - 1))
    device_output = min(dist_bl, dist_br, dist_tl, dist_tr)
    return str(device_output)

def batch_gen_inputs(batch_size,):
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(max_coord=10 ** 4, max_width_height=100))
    return inputs
