
import random


def gen_input(upper_limit: int) -> str:
    t = random.randint(1, upper_limit)
    test_cases = []
    for _ in range(t):
        n = random.randint(1, upper_limit)
        q = random.randint(1, upper_limit)
        vertices = [random.randint(1, n) for _ in range(n)]
        parents = [random.randint(1, i + 1) for i in range(1, n)]
        questions = []
        for _ in range(q):
            v = random.randint(1, n)
            l = random.randint(1, n)
            k = random.randint(1, n)
            questions.append([v, l, k])
        test_case = f'{n} {q}\n'
        test_case += ' '.join(map(str, vertices)) + '\n'
        test_case += ' '.join(map(str, parents)) + '\n'
        for question in questions:
            test_case += ' '.join(map(str, question)) + '\n'
        test_cases.append(test_case)
    input_string = f'{t}\n' + ''.join(test_cases)
    return input_string

def batch_gen_inputs(batch_size,) -> list:
    inputs = [gen_input(5) for _ in range(batch_size)]
    return inputs
