import random


def gen_input(t: int, n: list, a: list) -> str:
    assert 1 <= t <= 100, 'Invalid number of test cases'
    assert all((1 <= len(arr) <= 2 * 10 ** 5 for arr in a)), 'Invalid array length in one or more test cases'
    assert all((all((1 <= el <= 10 ** 9 for el in arr)) for arr in a)), 'Invalid array element in one or more test cases'
    assert sum(n) <= 2 * 10 ** 5, 'Sum of array lengths exceeds maximum limit'
    input_str = str(t) + '\n'
    for i in range(t):
        input_str += str(n[i]) + '\n'
        input_str += ' '.join((str(el) for el in a[i])) + '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        t = random.randint(1, 10)
        n = [random.randint(1, 10) for _ in range(t)]
        a = [[random.randint(1, 10 ** 9) for _ in range(n[i])] for i in range(t)]
        inputs.append(gen_input(t, n, a))
    return inputs
