# TEST_RESULT: True
from typing import List, Set, Tuple

def generate_subsequences(arr: List[int], idx: int, subseq: List[int], subsequences: List[List[int]]) -> None:
    if idx == len(arr):
        subsequences.append(subseq.copy())
        return
    generate_subsequences(arr, idx + 1, subseq, subsequences)
    subseq.append(arr[idx])
    generate_subsequences(arr, idx + 1, subseq, subsequences)
    subseq.pop()

def is_increasing(subseq: List[int]) -> bool:
    for i in range(1, len(subseq)):
        if subseq[i] <= subseq[i - 1]:
            return False
    return True

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    n = int(lines[0])
    arr = list(map(int, lines[1].split()))
    subsequences = []
    generate_subsequences(arr, 0, [], subsequences)
    xor_results = set()
    for subseq in subsequences:
        if not is_increasing(subseq):
            continue
        xor_value = 0
        for num in subseq:
            xor_value ^= num
        xor_results.add(xor_value)
    xor_results = sorted(list(xor_results))
    return f"{len(xor_results)}\n{' '.join(map(str, xor_results))}"
