import random

def gen_input(max_n, max_m, max_q):
    n = random.randint(1, max_n)
    m = random.randint(1, min(n * (n - 1) // 2, max_m))
    q = random.randint(0, max_q)
    w = [random.randint(1, 10 ** 9) for _ in range(n)]
    railways = []
    for _ in range(m):
        (u, v) = random.sample(range(1, n + 1), 2)
        d = random.randint(1, 10 ** 9)
        railways.append((u, v, d))
    incidents = []
    for _ in range(q):
        k = random.randint(1, n)
        x = random.randint(1, 4 * 10 ** 8)
        incidents.append((k, x))
    input_str = f'{n} {m} {q}\n'
    input_str += ' '.join((str(w_i) for w_i in w)) + '\n'
    for (u, v, d) in railways:
        input_str += f'{u} {v} {d}\n'
    for (k, x) in incidents:
        input_str += f'{k} {x}\n'
    return input_str

def batch_gen_inputs(batch_size,):
    test_inputs = []
    for _ in range(batch_size):
        test_inputs.append(gen_input(10, 20, 5))
    return test_inputs
