import random
import numpy as np

def gen_input(t_max=100, n_max=10, m_max=19):
    t = random.randint(1, t_max)
    inputs = []
    for _ in range(t):
        n = random.randint(1, n_max)
        m = random.randint(1, m_max)
        k = random.randint(1, n)
        field = np.random.choice(['.', '*'], size=(n, m))
        inputs.append(f'{n} {m} {k}\n' + '\n'.join((''.join(row) for row in field)))
    return f'{t}\n' + '\n'.join(inputs)

def batch_gen_inputs(batch_size,):
    return [gen_input(t_max=10, n_max=5, m_max=10) for _ in range(batch_size)]
