import random

def gen_input(n: int) -> str:
    """
    Generate a single test case for the problem. 
    
    Arguments:
    n -- The size of the sequence.
    
    Returns:
    A string representing a single test case.
    """
    sequence = [random.randint(1, 2 * 10 ** 5) for _ in range(n)]
    return f"{n}\n{' '.join(map(str, sequence))}\n"

def batch_gen_inputs(batch_size,) -> list:
    """
    Generate multiple test cases for the problem. 
    
    Returns:
    A list of strings, where each string represents a single test case.
    """
    test_cases = [gen_input(random.randint(1, 20)) for _ in range(batch_size)]
    return test_cases
