/*
 * Decompiled with CFR 0.152.
 */
import agents.robinBaumgarten.Agent;
import engine.core.MarioGame;
import engine.core.MarioResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class PlayAstar {
    public static void printResults(MarioResult marioResult) {
        System.out.println("****************************************************************");
        System.out.println("Game Status: " + marioResult.getGameStatus().toString() + " Percentage Completion: " + marioResult.getCompletionPercentage());
        System.out.println("Lives: " + marioResult.getCurrentLives() + " Coins: " + marioResult.getCurrentCoins() + " Remaining Time: " + (int)Math.ceil((float)marioResult.getRemainingTime() / 1000.0f));
        System.out.println("Mario State: " + marioResult.getMarioMode() + " (Mushrooms: " + marioResult.getNumCollectedMushrooms() + " Fire Flowers: " + marioResult.getNumCollectedFireflower() + ")");
        System.out.println("Total Kills: " + marioResult.getKillsTotal() + " (Stomps: " + marioResult.getKillsByStomp() + " Fireballs: " + marioResult.getKillsByFire() + " Shells: " + marioResult.getKillsByShell() + " Falls: " + marioResult.getKillsByFall() + ")");
        System.out.println("Bricks: " + marioResult.getNumDestroyedBricks() + " Jumps: " + marioResult.getNumJumps() + " Max X Jump: " + marioResult.getMaxXJump() + " Max Air Time: " + marioResult.getMaxJumpAirTime());
        System.out.println("****************************************************************");
    }

    public static String getLevel(String string) {
        String string2 = "";
        try {
            string2 = new String(Files.readAllBytes(Paths.get(string, new String[0])));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    public static void playAstar(MarioGame marioGame, String string, boolean bl) {
        System.out.println("Running Interactive Play!");
        System.out.println("=========================");
        PlayAstar.printResults(marioGame.playAstar(new Agent(), PlayAstar.getLevel(string), 200, bl));
    }

    public static void playAstar(MarioGame marioGame, String string, boolean bl, String string2) {
        System.out.println("Running Interactive Play!");
        System.out.println("=========================");
        PlayAstar.printResults(marioGame.playAstar(new Agent(), PlayAstar.getLevel(string), 200, bl, string2));
    }

    public static void main(String[] stringArray) {
        MarioGame marioGame = new MarioGame();
        String string = stringArray[0];
        String string2 = stringArray[1];
        boolean bl = false;
        if (stringArray[1].equals("human")) {
            bl = true;
        }
        if (stringArray.length > 2) {
            String string3 = stringArray[2];
            PlayAstar.playAstar(marioGame, string, bl, string3);
        } else {
            PlayAstar.playAstar(marioGame, string, bl);
        }
    }
}

