#!/bin/bash -l
#SBATCH --job-name=fewshot_array_sgd
#SBATCH --time=0-6
#SBATCH --ntasks=1 --cpus-per-task=4 --mem=16G
#SBATCH --gres=gpu:rtx_2080:1
#SBATCH --array=0-74
#SBATCH --output=slurm/%x-%A-%a.out

conda activate LM-Kernel-FT-test

SEEDs=( 42 13 21 87 100 )
BSs=( 2 4 8 )
LRs=( 1e-4 5e-4 1e-3 5e-3 1e-2 )

WD=0

LOGITS=$(jq -n '{"SNLI": 3, "MNLI": 3, "trec": 6, "sst-5": 5}["'$TASK'"] // 2')
MAX_STEP=$(expr 32 \* $K \* $LOGITS)
EVAL_STEP=$(expr 4 \* $K \* $LOGITS)

INDEX=$SLURM_ARRAY_TASK_ID

SEED_INDEX=$(expr $INDEX % 5)
BS_INDEX=$(expr $INDEX / 5 % 3)
LR_INDEX=$(expr $INDEX / 15 % 5)

SEED=${SEEDs[$SEED_INDEX]}
BS=${BSs[$BS_INDEX]}
LR=${LRs[$LR_INDEX]}

REAL_BS=2
GS=$(expr $BS / $REAL_BS)
GRID_TAG="$GRID_TAG-bsz$BS-lr$LR-wd$WD"
SEED=$SEED GRID_TAG=$GRID_TAG NUM_GPU=1 TRAINER=standard EXTRA=$EXTRA \
    source run_fewshot.sh \
        --do_train \
        --do_eval \
        --evaluate_during_training \
        --max_steps $MAX_STEP \
        --logging_steps $EVAL_STEP \
        --eval_steps $EVAL_STEP \
        --num_train_epochs 0 \
        --max_step $MAX_STEP --eval_step $EVAL_STEP \
        --per_device_train_batch_size $REAL_BS \
        --per_device_eval_batch_size $REAL_BS  \
        --gradient_accumulation_steps $GS \
        --learning_rate $LR \
        --weight_decay $WD \
        --optimizer sgd \
        $@
