DATA_PATH=./data-bin/iwslt14.tokenized.de-en
BEAM_SIZE=5
LPEN=1.0
OUTPUT_PATH=merged
TRANS_PATH=${OUTPUT_PATH}/trans
RESULT_PATH=${TRANS_PATH}/
mkdir -p $RESULT_PATH

for i in {-10..19}; do
    CKPT="merged${i}.pt"
    echo "generating ${i}"
    export CUDA_VISIBLE_DEVICES=1; \
        fairseq-generate \
        ${DATA_PATH} \
        --path ${OUTPUT_PATH}/${CKPT} \
        --user-dir optim/ \
        --batch-size 128 \
        --beam ${BEAM_SIZE} \
        --lenpen ${LPEN} \
        --remove-bpe \
        --log-format simple \
        --source-lang de \
        --target-lang en \
    > ${RESULT_PATH}/res${i}.txt
done