# SODA

The implementation of SODA on CIFAR-10-C and CIFAR-100-C.

## Prerequisites:

- python == 3.10.8
- cudatoolkit == 11.7
- pytorch ==1.13.1
- torchvision == 0.14.1
- numpy, PIL, argparse, collections, math, random

## Datasets

Please download and organize [CIFAR-10-C][https://zenodo.org/record/2535967/files/CIFAR-10-C.tar?download=1]  and [CIFAR-100-C][https://zenodo.org/record/3555552/files/CIFAR-100-C.tar?download=1] in this structure:

```
BETA
├── data
    ├──CIFAR-10
    │   ├── CIFAR-10-C
    │   │   ├── brightness.npy
    │   │   ├── contrast.npy
    │   │   ├── ...
    │   │   ├── labels.npy
    ├──CIFAR-100
    │   ├── CIFAR-100-C
    │   │   ├── brightness.npy
    │   │   ├── contrast.npy
    │   │   ├── ...
    │   │   ├── labels.npy 
```

## Pre-trained Models

The checkpoints of pre-trained Resnet-50 can be downloaded (197MB) using the following command:

```
mkdir -p results/cifar10_joint_resnet50 && cd results/cifar10_joint_resnet50
gdown https://drive.google.com/uc?id=1MZN19o-5b2w-BI1ObIlnsJ8XBZvMuL77 && cd ../..
mkdir -p results/cifar100_joint_resnet50 && cd results/cifar100_joint_resnet50
gdown https://drive.google.com/uc?id=1C7knE2S9kKDYZrqd4Bo4S5lOgp7Le_DP && cd ../..
```

These models are obtained by training on the clean CIFAR10/100 images using [semi-supervised SimCLR](https://github.com/YuejiangLIU/semi-simclr).

## Adaptation on CIFAR-10-C

```
# offline SODA
bash scripts/run_offline_soda_10.sh

# offline SODA-R
bash scripts/run_offline_soda_r_10.sh

# offline DA-PGD
bash scripts/run_offline_pgd_10.sh

# offline DA-ZOO-Input
bash scripts/run_offline_zoo_input_10.sh

# offline DA-Direct
bash scripts/run_offline_direct_10.sh

# offline DA-PL
bash scripts/run_offline_pl_10.sh

# offline MA-SO
bash scripts/run_offline_ma_10.sh

# online SODA-O
bash scripts/run_online_soda_10.sh
```

## Adaptation on CIFAR-100-C

```
# offline SODA
bash scripts/run_offline_soda_100.sh

# offline SODA-R
bash scripts/run_offline_soda_r_100.sh

# offline DA-PGD
bash scripts/run_offline_pgd_100.sh

# offline DA-ZOO-Input
bash scripts/run_offline_zoo_input_100.sh

# offline DA-Direct
bash scripts/run_offline_direct_100.sh

# offline DA-PL
bash scripts/run_offline_pl_100.sh

# offline MA-SO
bash scripts/run_offline_ma_100.sh

# online SODA-O
bash scripts/run_online_soda_100.sh
```

