#!/usr/bin/env python

"""Print out a LaTeX table showing statistics on the sex of the
participants."""

import os
import pandas as pd
import sqlite3

db_connection = sqlite3.connect(f"/space/{os.getenv('USER')}/tomcat/tomcat.db")

with db_connection:
    sexes = [
        x[1] if x[1] is not None else "Not reported"
        for x in db_connection.execute(
            """
        SELECT id, sex from participant
    """
        ).fetchall()
        if x[0] > 0
    ]

    labels = ["Male", "Female", "Other", "Prefer not to say", "Not reported"]
    counts = {
        label: sexes.count(label)
        for label in labels
    }
    counts = pd.Series(counts)
    print(counts.to_latex())
