# tomcat-signal-correlation-analysis

This project is for analyzing the temporal EEG and fNIRS signal correlation with team score.

## Install dependencies

This project requires Python 3.11.

### Install dependencies with Conda

Ensure that Conda is already installed, then run the following command to install dependencies into a new conda environment

```
conda conda create -n tomcat-correlation python=3.11
conda activate tomcat-correlation
pip install -r requirements.txt
```

### Install dependencies with Pip

You can install the packages using Pip3 in a base environment or an environment created for this project, then run the follow command to install dependencies

```
pip3 install -r requirements.txt
```

### Install dependencies manually

If you want to set up environment and install dependencies manually, then you need the following packages

```
numpy
pandas
numpy
scipy
scikit-learn
notebook
matplotlib
tqdm
openpyxl

```

## Set up project

Ensure that you downloaded the ToMCAT signal data and the data validity table [here](tomcat.ivilab.org)

Set the following variables in the `config.py` file:

- `DATA_VALIDITY_PATH` is the full path to the data validity table.
- `SIGNAL_PATH` is the full path to the ToMCAT synchronized EEG and fNIRS data.
- `NUM_PROCESSES` number of processes to analyze the signals in parallel.

## Run project

After setting up the `config.py` file, you can launch the program (make sure that you are in the python environment with required dependencies installed):

### Analyze fNIRS data

```
python3 process_nirs.py
```

### Analyze EEG data

```
python3 process_eeg.py
```

## Output

The program will output the `.xlsx` files in the same directory as where the code is located.
