import torch

def log_and(*conds):
    # Given Boolean expressions, checks if all expressions are true

    if len(conds) < 2:
        raise ValueError('Need at least two conditions here.')
    
    bool_tensor = torch.logical_and(conds[0], conds[1])
    for cond in conds[2:]:
        bool_tensor = torch.logical_and(bool_tensor, cond)

    return bool_tensor

def log_not(a):
    return torch.logical_not(a)
