from .functions.binarize import reswish_binarize
from .qlinear import QLinear


class BinLinear(QLinear):
    """
        Binary Linear module.
    """
    def __init__(self, *args, beta, **kwargs):
        """
        :param list args: args for :class:`antgine.modules.quantization.qlinear.QLinear`.
        :param float beta: beta assigned to Reswish.
        :param dict[str, any] kwargs: kwargs for :class:`antgine.modules.quantization.qlinear.QLinear`.
        """
        super().__init__(*args, qfunc=lambda x: reswish_binarize(x, beta), **kwargs)
