def rsa(entry, experiment, p, rsa_lambda, seed):
    return {'acc': entry['top1'],
            'agg': 'rsa',
            'attack': experiment.attack,
            'f': experiment.F,
            'iid_type': experiment.iid_type,
            'n': str(experiment.N),
            'num_type': experiment.num_type,
            'p_norm': p,
            'result_type': entry['_meta']['type'],
            'round': entry['E'],
            'rsa_lambda': str(rsa_lambda),
            'seed': seed}

def fltrust(entry, experiment, p, param1, seed):
    return {'acc': entry['top1'],
            'agg': 'fltrust',
            'attack': experiment.attack,
            'f': experiment.F,
            'iid_type': experiment.iid_type,
            'n': str(experiment.N),
            'num_type': experiment.num_type,
            'p_norm': p,
            'result_type': entry['_meta']['type'],
            'round': entry['E'],
            'param1': str(param1),
            'seed': seed}

def krum(entry, experiment, p, krum_m, reduce_method, n_dims, dims, seed):
    return {'acc': entry['top1'],
            'attack': experiment.attack,
            'agg': 'krum',
            'dims': (n_dims if reduce_method is None else dims),
            'f': experiment.F,
            'iid_type': experiment.iid_type,
            'krum_m': krum_m,
            'n': str(experiment.N),
            'num_type': experiment.num_type,
            'p_norm': p,
            'reduce_method': str(reduce_method),
            'result_type': entry['_meta']['type'],
            'round': entry['E'],
            'seed': seed}


def cclip(entry, experiment, p, tau, momentum, seed):
    return {'acc': entry['top1'],
            'agg': 'cclip',
            'attack': experiment.attack,
            'f': experiment.F,
            'iid_type': experiment.iid_type,
            'n': str(experiment.N),
            'num_type': experiment.num_type,
            'p_norm': str(p),
            'result_type': entry['_meta']['type'],
            'round': entry['E'],
            'seed': seed,
            'tau': tau,
            'momentum': momentum}


def avg(entry, experiment, seed):
    return {'acc': entry['top1'],
            'agg': 'avg',
            'attack': experiment.attack,
            'f': experiment.F,
            'iid_type': experiment.iid_type,
            'n': str(experiment.N),
            'num_type': experiment.num_type,
            'result_type': entry['_meta']['type'],
            'round': entry['E'],
            'seed': seed,}
