import logging

import torch


def get_vectorized_parameters(optimizer):
    c = []
    for group in optimizer.param_groups:
        for p in group["params"]:
            c.append(p.data.view(-1))
    return torch.cat(c)


def log(x):
    logging.getLogger("debug").info(x)


def log_dict(d):
    logging.getLogger("debug").info(d)
