from ..simulators.worker import ByzantineWorker


class SignFlippingWorker(ByzantineWorker):
    def __str__(self) -> str:
        return "SignFlippingWorker"

    def get_gradient(self):
        return -super().get_gradient()

    def get_update(self, server_iterate):
        results = self.compute_gradient()
        results['local_iterate'] = -self.get_gradient()
        return results

    def omniscient_callback(self):
        raise NotImplementedError
