# inf-func-ds-mu

code structure:

+ algorithm: WoodFsiher, SignSGD

+ analysis: executive codes for analysis

+ data: load data

+ experiments: executive codes for main experiments

  + pretrain
  
    + `python experiments/pretrain.py --network resnet18 --dataset imagenet` used for pretraining a resnet18 on original imagenet

    + `python experiments/pretrain.py --network resnet18 --dataset imagenet --random-remove --remove-cls-num k` used for pretraining a resnet18 on imagenet with $k$ classes randomly removed
    
    + `python experiments/pretrain.py --network resnet18 --dataset imagenet --influence-function-file --remove-cls-num k --inf-eval-method heuristic` used for pretraining a resnet18 on imagenet with $k$ classes removed according to the calculated influence function (evaluated by heuristic method)

    + `python experiments/pretrain.py --network resnet18 --dataset imagenet --influence-function-file --remove-cls-num k --inf-eval-method oneshot_optim` used for pretraining a resnet18 on imagenet with $k$ classes removed according to the calculated influence function (evaluated by oneshot optimization method)
    
  + influence function calculation
  
    + `python experiments/transfer_source_data_select.py --network resnet18 --dataset flowers102 --pretrained-path xxx` used for calculation of influence function transferring from pretrained path ckpt to the target dataset
    
  + downstream learning
  
    + `python experiments/downstream_learning.py --network resnet18 --dataset flowers102 --pretrained-path xxx --pretrained-ckpt zzz` used for downstream transfer learning from xxx/zzz.pth

+ scripts: batch running scripts on HPCC or other servers

+ tools: misc tools

PS. use `--dry-run` to avoid any log and test your code.
