# OZD
Code to reproduce the numerical experiments of the paper "Structured Zeroth-order for Non-smooth Optimization".


## Installing Dependences
___
To perform the experiments, we used [numpy](https://numpy.org/) (version used 1.22) and [matplotlib](https://matplotlib.org/stable/) (version used 3.5.1). The python version used is the 3.9.11.

Thus, you can reproduce the experiements by creating an Anaconda environment with the required packages
```
conda create -n "test_ozd" python=3.9.11 matplotlib=3.5.1 numpy=1.22
```
Then activate the virtual environment with
```
conda activate test_ozd
```

Alternatively, if you do not want to create a new Anaconda environment, you can just install dependences with pip
```
pip install numpy==1.22.2 matplotlib==3.5.1
```
## How to reproduce the experiments
___
Numerical results can be reproduced by executing the following scripts:
- `change_l.py`: it reproduces the experiments about the performance of the Algorithm changing the number of directions (i.e. Figure 1 of the paper). 
```
python3 change_l.py
```
- `fd_comparison_smooth.py`: it reproduces the comparison between finite-difference methods on the convex smooth target (i.e. left plot of Figure 2 of the paper).
```
python3 fd_comparison_smooth.py
```
- `fd_comparison_nonsmooth.py`: it reproduces the comparison between finite-difference methods on the convex non-smooth target (i.e. right plot of Figure 2 of the paper).
```
python3 fd_comparison_nonsmooth.py
```
- `sglasso_exp.py`, `tv_exp.py`, `l1_exp.py`, `infnorm_exp.py`, `huberloss_exp.py`, `enet_exp.py`: they reproduce the comparison between our algorithm and finite-difference methods on Sparse Group Lasso, Total Variation, L1-norm, Infinity norm, Huber loss and Elastic net respectively (Figure 6 of the paper). Example:
```
python3 sglasso_exp.py
```
- `cpu_time_comparison_nonsmooth.py`, `cpu_time_comparison.py`: comparison in CPU time in solving the two problems in Section 4. Example:
```
python3 cpu_time_comparison_nonsmooth.py
```

The other scripts (`utils.py`, `algorithms.py` and `other_nonsmooth_utils.py`) contains utility functions and the implementation of the algorithm and of different methods to generate directions (used to make the comparisons).