include("model.jl")
include("../../inference/MixFlow/MixFlow.jl")
include("../common/plotting.jl")
include("../common/result.jl")
include("../common/tunning.jl")
using LogExpFunctions, ProgressMeter

n_lfrg = 40
o = MixFlow.HamFlow(
    d,
    n_lfrg,
    logp,
    ∇logp,
    randn,
    logq,
    randn,
    MixFlow.lpdf_normal,
    MixFlow.∇lpdf_normal,
    MixFlow.cdf_normal,
    MixFlow.invcdf_normal,
    MixFlow.pdf_normal,
)

MF = JLD.load("result/mfvi.jld")
μ, D = MF["μ"], MF["D"]
el_svi = MF["elbo"]

ELBO_plot(
    o;
    elbo_svi=el_svi,
    μ=μ,
    D=D,
    eps=[5e-3, 8e-3, 1e-2],
    Ns=[20, 50, 100, 200, 400, 600],
    elbo_size=500,
    res_name="el_tune.jld",
    fig_name="lr_elbo_tune.png",
    title="Linear regression",
    xtickfont=font(18),
    ytickfont=font(18),
    guidefont=font(18),
    legendfont=font(18),
    titlefontsize=18,
    xrotation=20,
    fig_size=(1400, 600),
)