# Code for NeurIPS 2023 Submission

## How to reproduce

The steps below are used to reproduce the experiments of the paper.

### Step 1) Create venv environment

    source create_environment.sh [cpu/cu116/cu117]

This will create a venv environment called `neurips` with cpu or cuda (11.6/11.7) support depending on your choice.

We will be using the package `pydgn 1.3.0.post1` to run the experiments.

### Step 2) Create dataset

You can prepare the datasets using the following command

    pydgn-dataset --config-file DATA_CONFIGS/config_abalone.yml

(and similarly for the other datasets using the configuration files in the `DATA_CONFIGS` folder.)

### Step 3) Launch all experiments

Make sure you configure your hardware requirements in the configuration files present in the `MODEL_CONFIGS` folder.
Then you can run

    source mlp_exp.sh
    source simpledgn_exp.sh    
    source gin_exp.sh    
    source gcn_exp.sh    

### Optional Step) Launch an individual experiment (remove [--debug] to parallelize as in step 3)

    pydgn-train --config-file MODEL_CONFIGS/pedalme/mlp_abalone.yml --debug

This will launch model selection and risk assessment for the MLP and compute the final scores. You can use different
configuration files to launch different experiments.

## Notebooks

You can use the jupyter notebooks to inspect our qualitative experiments and animations for the theoretical results.
