import numpy as np
import pandas as pd
import random
from sklearn.preprocessing import MinMaxScaler
    
# Read the appropriate dataset
def data_reader(dataset):
    if dataset == "credit_card_default":
        df = pd.read_excel("Data/credit_card_default.xls", header = 1, index_col = 0)
        D_1 = df[df['MARRIAGE'] == 1].iloc[:, :-1].to_numpy()
        D_2 = df[df['MARRIAGE'] > 1].iloc[:, :-1].to_numpy()
    if dataset == "give_me_credit":
        df = pd.read_csv('Data/give_me_credit.csv' , usecols=range(1, 12))
        D_1 = df[df['NumberOfDependents'] == 0].to_numpy()
        D_2 = df[df['NumberOfDependents'] > 0].to_numpy()
    if dataset == "adult":
        df = pd.read_csv("Data/adult.txt", header = None, sep = ", ", engine = 'python')
        df = df.iloc[:, :-2]
        mask = df.iloc[:, 5] >= 2
        D_1 = df.loc[mask].values
        D_2 = df.loc[~mask].values 
    random.shuffle(D_1)
    random.shuffle(D_2)
    scaler = MinMaxScaler()
    scaler.fit(D_1)
    D_1_scaled = scaler.transform(D_1)
    scaler.fit(D_2)
    D_2_scaled = scaler.transform(D_2)
    #print(len(D_1), len(D_2))
    return (D_1_scaled, D_2_scaled)
    
    
    
    