import numpy as np

# Distance for across-cluster similarity
def across_distance(x,y,a,b,s):
    dif = np.abs(a * x - b * y + s)
    return ((dif*dif*dif).sum()) ** (1 / 3)
 
# Predictor based on the shortest distance to one representative element; also identify new queries
def Predictor(R_1, R_2, x, y, a, b, s, Q):
    distances_x = np.linalg.norm(R_1 - x, axis=1) 
    min_idx = np.argmin(distances_x) 
    r_x = R_1[min_idx]
    distances_y = np.linalg.norm(R_2 - y, axis=1) 
    min_idy = np.argmin(distances_y) 
    r_y = R_2[min_idy]
    Q.add((tuple(r_x), tuple(r_y)))
    return across_distance(r_x, r_y, a, b, s)

# k-center approach to choose representative elements    
def Cluster(S, eps, rho):
    R = np.empty((0, len(S[0])))
    for x in S:
        incl = True
        for r in R:
            if np.linalg.norm(x - r) <= 2 * eps * rho:
                incl = False
                break
        if incl:
            R = np.append(R, [x], axis = 0)
    return R
