>📋  A template README.md for code accompanying a Machine Learning paper

# Active Learning for Semantic Segmentation with Multi-class Label Query

This repository is the official implementation of [Active Learning for Semantic Segmentation with Multi-class Label Query]. 

## Requirements

To install requirements:

```setup
conda env create -f actsegmul.yml
```

## Dataset & pretrained model
Prepare dataset:

- Download superpixel region and multi-class label in [data](https://drive.google.com/file/d/1w0uAZtc9rjiufbMamd4U2FROaEuBqy6n/view?usp=share_link), and put 'data' under `<GitRoot>`.
- Download [Cityscapes](https://www.cityscapes-dataset.com) and put 'gtFine' and 'leftImg8bit' in '`<GitRoot>`/data/Cityscapes' (check the following directory tree).

Prepare trained model:
- Download initial weight and pretrained model in [checkpoint](https://drive.google.com/file/d/15qK7JwfYRz9-FUg0CoECia0nmkeU8NeT/view?usp=share_link), and put 'checkpoint' under `<GitRoot>`.

The directory needs to be:
```
<GitRoot>
├── checkpoint
    ├── city_res50deepstem_imagenet_pretrained.tar
    ├── resnet50_deepstem.pth
├── data
    ├── Cityscapes
        ├── gtFine
        ├── leftImg8bit
        ├── superpixel_seed
├── ...
```

## Training

To train the model(s) in the paper, run this command:

```train
bash script/train_city_mul_res50.sh
```

## Evaluation

To evaluate trained model, run:

```eval
python eval_AL.py -p checkpoint/eval \
--init_checkpoint checkpoint/<your_checkpoint.tar> \
--model deeplabv3pluswn_resnet50deepstem \
--separable_conv \
--stage2 \
--method eval_naive \
--wandb_tags none \
--loader region_cityscapes_all \
--train_transform eval_spx \
--nseg 2048 \
--val_batch_size 1 \
--dontlog
```

To evaluate provided pre-trained models, run:

```eval provided checkpoint for 5 rounds
bash script/eval_city_mul_res50.sh
```