# Overcoming Recency Bias of Normalization Statistics in Continual Learning: Balance and Adaptation

This repository is the official implementation of *Overcoming Recency Bias of Normalization Statistics in Continual Learning: Balance and Adaptation*.

## Requirement

The code is based on PyTorch framework. To install requirements:

```setup
pip install -r requirements.txt
```
Our code uses [Weights & Biases](https://wandb.ai/site) to log the results. After installing the requirements, type `wandb login` to bind your api key.

## Usage
We provide a launcher to run the experiments conveniently. For instance, use the following command to reproduce the experiments in Table 1 and Table 2 of the paper. 
```shell
python run.py --interpreter `which python` --num_seeds 3
```
During this process, all GPUs will be invoked automatically. It took about 7 hours to complete one seed on our machine (8x NVIDIA RTX A4000).

It is also feasible to run a single experiment manually by `utils/main.py`. The main algorithm is contained in `models/utils/adab2n.py`.


Complete usage of `run.py`:
```
usage: run.py [-h] [--interpreter INTERPRETER] [--coldsecs COLDSECS] [--waitsecs WAITSECS] [--usage_threshold USAGE_THRESHOLD] [--logdir LOGDIR]
              [--models MODELS [MODELS ...]] [--num_seeds NUM_SEEDS] [--bs BS] [--epochs EPOCHS] [--datasets DATASETS [DATASETS ...]] [--methods METHODS [METHODS ...]]
              [--buffer_mode {reservoir,ring}] [--nowandb] [--wandb_project WANDB_PROJECT]

options:
  -h, --help            show this help message and exit
  --interpreter INTERPRETER
                        Interpreter location
  --coldsecs COLDSECS   Seconds to cool down after starting a run
  --waitsecs WAITSECS   Seconds to sleep while waiting for an idle GPU
  --usage_threshold USAGE_THRESHOLD
                        Threshold for determining idle GPUs
  --logdir LOGDIR       The save path for the command line output of each run
  --models MODELS [MODELS ...]
                        Continual learning models to run
  --num_seeds NUM_SEEDS
                        Number of seeds
  --bs BS               Batch size
  --epochs EPOCHS       Number of epochs
  --datasets DATASETS [DATASETS ...]
                        Datasets to run
  --methods METHODS [METHODS ...]
                        Normalization layers to replace BN
  --buffer_mode {reservoir,ring}
                        Replay buffer mode
  --nowandb             Inhibit wandb logging
  --wandb_project WANDB_PROJECT
                        Wandb project name

```
## Citation

## Acknowledgements
Our implementation is built upon the awesome [mammoth](https://github.com/aimagelab/mammoth) repository.
