%--- Description ---%
%
% Filename: get_fig_param.m
% Authors: Ben Adcock, Simone Brugiapaglia and Clayton Webster
% Part of the book "Sparse Polynomial Approximation of High-Dimensional
% Functions", SIAM, 2021
%
% Description: loads a set of default plotting parameters
%
% Outputs:
% ms - markersize
% lw - linewidth
% fs - fontsize
% colors - RGB colors
% markers - plot markers
% AlphaLevel - degree of transparency in shaded plots
%
% Update (May 2023): modified by the authors of "CS4ML: A general framework
% for active learning with arbitrary data based on Christoffel functions"
%
% Description: edited the function to output the plot using the same color
% every two curves, line dash and marker for first method, and dash-dahs
% and marker for second method

function [ms, lw, fs, colors, markers, AlphaLevel] = get_fig_param()

ms = 8;
lw = 1.5;
fs = 17;

colors = {[0.8500    0.3250    0.0980],...
          [0    0.4470    0.7410],...
          [0.8500    0.3250    0.0980],...
          [0    0.4470    0.7410],...
          [0.8500    0.3250    0.0980],...
          [0    0.4470    0.7410],...
          [0.8500    0.3250    0.0980],...
          [0    0.4470    0.7410]};

markers = {'-*','--*','-^','--^','-o','-o','-s','-s','-v','-v','-+','-+'};

AlphaLevel = 0.1;

