#!/bin/bash

task_splits=../data/task_splits/sparc/
table_data=../data/task_splits/sparc/
output=../data/task_splits/sparc/

echo "Start download NLTK data"
python download_nltk.py
echo "Finish."

echo "Start process the SparC task streams ..."
python data_process.py --data_path ${task_splits} --table_path ${table_data} --output ${output} --mode stream
echo "Finish."

echo "Start generate SemQL from SQL."
python sql2SemQL.py --data_path ${output} --table_path ${table_data} --output ${task_splits} --mode stream
echo "Finish."
