import os
import platform
import sys
import time
import pickle
from IPython.display import clear_output
import matplotlib
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
import random

import sklearn
from sklearn.metrics import mean_absolute_error, mean_squared_error, r2_score
from sklearn.model_selection import train_test_split

import tensorflow as tf
import tensorflow
from tensorflow import keras
from tensorflow.keras.models import Sequential, Model, model_from_json, load_model
from tensorflow.keras.layers import Dense, Input, Add, Lambda, Dropout, Subtract, Multiply, Concatenate, Dot, BatchNormalization, Activation, LeakyReLU, ReLU
from tensorflow.keras.losses import mse
from keras import backend as K
from tensorflow.keras import regularizers

import keras_tuner
from keras_tuner import Hyperband, BayesianOptimization


### Base functions
def fix_seed(seed):
    # Numpy
    np.random.seed(seed)
    # Tensorflow
    tf.random.set_seed(seed)
    # for built-in random
    random.seed(seed)
    # for hash seed
    os.environ["PYTHONHASHSEED"] = str(seed)
    
class PrintDot(keras.callbacks.Callback):
    def on_epoch_end(self, epoch, logs):
        if epoch%100==0: print('')
        if epoch%100==1: print(epoch)
        print('.', end='')
        
early_stop = keras.callbacks.EarlyStopping(monitor='val_loss', patience=10)