using LambertW, SpecialFunctions;

function get_threshold(threshold, δs, r, K, s)
    if threshold == "GK16"
        βs = GK16.(δs);
    else
        @error threshold * ": not implemented"
    end
    βs;
end

# Threshold recommended by (Garivier and Kaufmann, 2016) and used extensively by subsequent publications.
struct GK16
    δ;
end

abbrev(β::GK16) = "GK16";

function (β::GK16)(t)
    log((log(t)+1)/β.δ)
end


barW(x, k) = -lambertw.(-exp.(-x), k);
bonus_ucb(x, s, α) = barW(2 * s * α * log(x) + 2 * log(2 + log(x)) + 3 - 2 * log(2), -1);
