## Quick Start
### 1. Install [Singularity](https://sylabs.io/guides/3.5/user-guide/introduction.html) (optional)
If you don't want to install Singularity, make sure that you have all dependecies from Singularity.def (python3, numpy, pytorch, etc.)

a. Pull an image 
````
singularity pull library://k3nfalt/default/python_ml:sha256.37fc4c8d86b92f0ac80f7a3a729d2a3d0294ea3c3895957bc7f647f1ef922745
````
b. Open a shell console of the image
````
singularity shell --nv ~/python_ml_sha256.37fc4c8d86b92f0ac80f7a3a729d2a3d0294ea3c3895957bc7f647f1ef922745.sif
````
### 2. Prepare scripts for experiments
````
source prepare.sh && python3.7 code/distributed_optimization_library/experiments/asynchronous/config_async.py --dataset_path NA --dumps_path SOME_PATH --experiments_name async_sgd_nn_100_dim_1000_noise_0_01_delay_sqrt_type_zero_last_iter_100000 --num_nodes 100 --step_size_range -14 4 --number_of_iterations 100000 --algorithm_names rennala asynchronous_sgd --quad_dim 1000 --quad_noise 0.01 --rennala_batch_size_list 1 5 10 20 40 80 100 --delays sqrt --quad_strongly_convex_constant 1e-6 --quad_type_noise zero-last
````
````
source prepare.sh && python3.7 code/distributed_optimization_library/experiments/asynchronous/config_async.py --dataset_path NA --dumps_path SOME_PATH --experiments_name async_sgd_nn_1000_dim_1000_noise_0_01_delay_sqrt_type_zero_last_iter_300000 --num_nodes 1000 --step_size_range -14 4 --number_of_iterations 300000 --algorithm_names rennala asynchronous_sgd --quad_dim 1000 --quad_noise 0.01 --rennala_batch_size_list 1 5 10 20 40 80 100 200 500 1000 --delays sqrt --quad_strongly_convex_constant 1e-6 --quad_type_noise zero-last --not_only_intel --quality_check_rate 100
````
````
source prepare.sh && python3.7 code/distributed_optimization_library/experiments/asynchronous/config_async.py --dataset_path NA --dumps_path SOME_PATH --experiments_name async_sgd_nn_10000_dim_1000_noise_0_01_delay_sqrt_type_zero_last_iter_300000 --num_nodes 10000 --step_size_range -14 4 --number_of_iterations 300000 --algorithm_names rennala asynchronous_sgd --quad_dim 1000 --quad_noise 0.01 --rennala_batch_size_list 1 5 10 20 40 80 100 200 500 1000 --delays sqrt --quad_strongly_convex_constant 1e-6 --quad_type_noise zero-last --not_only_intel --quality_check_rate 100
````
### 3. Execute scripts
````
sh SOME_PATH/EXPERIMENTS_NAME/singularity_*.sh
````
### 4. Plot results with the script prepare.sh in the folder plot
