EXP_NAME=$1
LR=$2
ENABLE=$3
PB=$4
MB=$5
SQMB=$6
SCALE_TYPE=$7
ROUND_TYPE=$8
Q_ORACLE=$9
MODE=$10
WARMUP=2000
WARMUP_RATIO=0.6
NUM_EPOCHS=2


if [ $NUM_GPUS -gt 1 ]; then
    DIST="--mixed_precision=fp16 --multi_gpu --num_processes=$NUM_GPUS --main_process_port=$MAIN_PORT"
    BS=$((48 / $NUM_GPUS))
else
    DIST="--mixed_precision=fp16 --num_processes=1 --main_process_port=$MAIN_PORT"
    BS=48
fi

if [ "$DATA" = "squad_v2" ]; then
    DATAARGS="--dataset_name $DATA --version_2_with_negative"
else
    DATAARGS="--dataset_name $DATA"
fi

accelerate launch $DIST \
    run_qa_no_trainer.py \
    --model_name_or_path roberta-large \
    $DATAARGS \
    --output_dir $EXP_NAME \
    --per_device_train_batch_size $BS \
    --learning_rate $LR \
    --num_train_epochs $NUM_EPOCHS \
    --max_seq_length 384 \
    --pad_to_max_length \
    --doc_stride 128 \
    --weight_decay 0.01 \
    --adam_beta1 0.9 \
    --adam_beta2 0.98 \
    --adam_epsilon 1e-6 \
    --num_warmup_steps $WARMUP \
    --warmup_ratio $WARMUP_RATIO \
    --with_tracking \
    --checkpointing_steps 20000 \
    --lpmm-enable $ENABLE \
    --pb $PB \
    --mb $MB \
    --sqmb $SQMB \
    --q_oracle $Q_ORACLE \
    --scale_type $SCALE_TYPE \
    --round_type $ROUND_TYPE \
    --optim_mode $MODE