from tensorflow.keras.utils import Sequence
import numpy as np

from data_engineering.generate_synthetic_dataset import generate_brownian_asset_dynamics

EPS = 1e-8


class OSMCBatchGenerator(Sequence):

    def __init__(self, config, option_parameters, num_samples_per_epoch, seed=0, mode='test'):
        self.B = config['batch_size']
        self.num_samples_per_epoch = num_samples_per_epoch
        self.option_parameters = option_parameters
        self.seed = seed
        self.mode = mode
        self.epoch = 0


    def __len__(self):
        return self.num_samples_per_epoch

    def __getitem__(self, idx):

        X, R = generate_brownian_asset_dynamics(self.option_parameters, self.B, rs=(self.seed + idx))
        L = X.shape[1]
        batch_t = np.tile(np.expand_dims(np.arange(L, dtype=float), axis=(0, 2)), (self.B, 1, 1)) / L

        return [batch_t, np.expand_dims(R, axis=2), X], [R]