# Copyright (c) 2023
# Copyright holder of the paper "End-to-End Meta-Bayesian Optimisation with Transformer Neural Processes".
# Submitted to NeurIPS 2023 for review.
# All rights reserved.

import os


def get_eda_datasets(rootdir):
    eda_data_root = os.path.join(rootdir, 'eda_data')
    eda_files = os.listdir(eda_data_root)
    eda_datasets = [f for f in eda_files if '.pkl' in f and f != 'eda_ga500_data.pkl']
    eda_gps = [f for f in eda_files if '.pt' in f]

    circuits = [a.split("dataset_")[1].split(".pkl")[0] for a in eda_datasets]
    n_circuits = len(circuits)
    split = int(0.7 * n_circuits), int(0.8 * n_circuits)  # 70% train, 10% val, 20% test
    train_circuits = circuits[:split[0]]
    val_circuits = circuits[split[0]:split[1]]
    test_circuits = circuits[split[1]:]

    gps_train = [f for f in eda_gps if f.split("gp_")[1].split(".pt")[0] in train_circuits]
    gps_val = [f for f in eda_gps if f.split("gp_")[1].split(".pt")[0] in val_circuits]
    gps_test = [f for f in eda_gps if f.split("gp_")[1].split(".pt")[0] in test_circuits]

    datasets_train = eda_datasets[:split[0]]
    datasets_val = eda_datasets[split[0]:split[1]]
    datasets_test = eda_datasets[split[1]:]

    gps_train = [os.path.join(eda_data_root, f) for f in gps_train]
    gps_val = [os.path.join(eda_data_root, f) for f in gps_val]
    gps_test = [os.path.join(eda_data_root, f) for f in gps_test]
    datasets_train = [os.path.join(eda_data_root, f) for f in datasets_train]
    datasets_val = [os.path.join(eda_data_root, f) for f in datasets_val]
    datasets_test = [os.path.join(eda_data_root, f) for f in datasets_test]

    return datasets_train, gps_train, datasets_val, gps_val, datasets_test, gps_test
