
data {

    // int<lower = 0> N;
    int<lower = 0> d;
    int<lower = 1> P;
    vector<lower=0> [P] N;
    real s;

    int mon_terms;
    int mult_terms3;

    int i_4_terms_m_m;
    int i_4_terms_m_m_I;
    int i_4_terms_m_mu;
    int i_6_terms_m_m_mu;


    vector [mult_terms3] multinomial_coefficients3;

    matrix [mult_terms3, d] multinomial_exponents3;


    int t_m     [mon_terms,2];
    int t_m_I   [mon_terms,d,2];
    int t_m_m   [mon_terms,mon_terms,2];


    int i_partitions_4_m_m    [i_4_terms_m_m   ,3, 2, 3];
    int i_partitions_4_m_m_I  [i_4_terms_m_m_I ,3, 2, 3];
    int i_partitions_4_m_mu   [i_4_terms_m_mu  ,3, 2, 3];

    int i_partitions_6_m_m_mu   [i_6_terms_m_m_mu, 15,  3, 3];

    int degrees_m  [mon_terms];

    int lkj;


    // vector[mon_terms-1] pert_ss;
    // vector[mon_terms-1] DP_VAR;
    matrix[P, mon_terms-1] pert_ss;
    matrix[P, mon_terms-1] DP_VAR;
}

transformed data{
  int J=0;

  int  non_zeros3  [mult_terms3, d];
  for (i in 1 : mult_terms3) {
      J=1;
      for (l in 1:d) {
          if (multinomial_exponents3[i,l] >0.0) {
              non_zeros3[i,J] = l;
              J+=1;
           }
       }
       for (l in J:d)
       non_zeros3[i,l]=-1;
  }


}

parameters {

  unit_vector [d]  theta;
  //corr_matrix[d] Omega;
  cholesky_factor_corr[d] L_Omega;


  vector<lower=0, upper=2>[d] tau;

  real <lower= 0.001, upper = s> theta_norm;
}

transformed parameters {


  real sqrt_norm = sqrt(theta_norm);

  vector[d] theta_DP_scaled = sqrt_norm* theta;

}


model {
  vector [mon_terms-1] EXP;
  vector [mult_terms3] theta_term_coef_prod3;

  matrix [d,d] Sigma;


  real term;
  real E_XY = 0.0;
  real moment =0;
  real count =0.0;
  real part1 =0.0;
  real part2 = 0.0;

  real first_term  = 0.0;
  real second_term = 0.0;

  real min_eig=0.0;

  int degrees_m1_m2 = 0;
  int temp =0;

  int ijk_4_mm=1;

  int ijk_4_mmI=1;
  int ijk_4_mmu=1;
  int ijk_6=1;



  matrix[mon_terms-1, mon_terms-1] COV;

  theta_norm ~ chi_square(d)T[0,s];
  theta ~ std_normal();


  tau ~ normal(1.0, 1.0);

  L_Omega ~ lkj_corr_cholesky(lkj);

  Sigma = quad_form_diag(L_Omega*L_Omega', tau);




  for (i in 1 : mult_terms3) {
      term = 1.0;
      for (l in 1:d) {
              temp = non_zeros3[i,l];
              if (temp == -1) break;
              term*=pow(theta_DP_scaled[temp],multinomial_exponents3[i,temp]);
       }
       theta_term_coef_prod3[i]=term*multinomial_coefficients3[i];
  }





  for (i in 2 : mon_terms) {
        if (degrees_m[i] == 2) {
            EXP[i-1] = Sigma[t_m[i,1],t_m[i,2]];

        } else if (degrees_m[i] == 1){
              first_term  = 0.0;
              second_term = 0.0;
              for (k in 1:d){
                  first_term += (theta_DP_scaled[k]*Sigma[t_m_I[i,k,1],t_m_I[i,k,2]]);
              }
              for (k in 1:mult_terms3){
                    moment=0.0;
                    for (each_partition in i_partitions_4_m_mu[ijk_4_mmu]) {
                            count = each_partition[1,3];

                            if (count <= 0.0) break;

                            term = 1.0;
                            for (pair in each_partition) {
                              term *= (Sigma[pair[1], pair[2]]);
                            }
                            moment += (count*term);
                    }

                  second_term += (theta_term_coef_prod3[k]*moment);
                  ijk_4_mmu+=1;
              }


              EXP[i-1] = -((second_term/24.0)  -(first_term*0.5));
        }
    }



    for (i in 2 : mon_terms) {

     for (j in 2 : i) {

          E_XY = 0.0;

          degrees_m1_m2=degrees_m[i]+degrees_m[j];

          if (degrees_m1_m2 == 2){
                E_XY = Sigma[t_m_m[i,j,1],t_m_m[i,j,2]];

          } else if (degrees_m1_m2 == 4){
              moment=0.0;
              for (each_partition in i_partitions_4_m_m[ijk_4_mm]) {
                    count = each_partition[1,3];

                    if (count <= 0.0) break;

                    term = 1.0;
                    for (pair in each_partition) {
                        term *= (Sigma[pair[1], pair[2]]);
                    }
                    moment += (count*term);
              }
              E_XY = moment;
             ijk_4_mm+=1;
            } else if (degrees_m1_m2 == 3){

              first_term  = 0.0;
              second_term = 0.0;

              for (k in 1:d){
                    moment=0.0;
                    for (each_partition in i_partitions_4_m_m_I[ijk_4_mmI]) {
                            count = each_partition[1,3];

                            if (count <= 0.0) break;

                            term = 1.0;
                            for (pair in each_partition) {
                              term *= (Sigma[pair[1], pair[2]]);
                            }
                            moment += (count*term);
                   }
                  first_term += (theta_DP_scaled[k]*moment);
                  ijk_4_mmI+=1;

              }
              for (k in 1:mult_terms3){
                    moment=0.0;
                    for (each_partition in i_partitions_6_m_m_mu[ijk_6]) {
                            count = each_partition[1,3];
                            if (count <= 0.0) break;

                            term = 1.0;
                            for (pair in each_partition) {
                              term *= (Sigma[pair[1], pair[2]]);
                            }
                            moment += (count*term);
                    }

                  second_term += (theta_term_coef_prod3[k]*moment);
                  ijk_6+=1;
              }


              E_XY = -((second_term/24.0) -(first_term*0.5) );

            }

        COV[i-1,j-1] = (E_XY- EXP[i-1]*EXP[j-1]);

      COV[j-1,i-1] =  COV[i-1,j-1];
     }
    }

    for (p in 1 :P) {
      pert_ss[p] ~ multi_normal_cholesky(N[p]*EXP,cholesky_decompose(add_diag(N[p]*COV, DP_VAR[p])));
    }
}
