import numpy as np
from PASS import PASS

def generate_approx_ss_noisy(X_clipped, y, eps, GS, pass_object, lamb=2, seed=None):
    if np.min(y) == 0:
        print("Mapped y to +1/-1")
        y = 2*y - 1
    approx_ss = np.array([np.prod(np.power(ax*ay,pass_object.monomial_exponents), axis=1)
                          for ax,ay in zip(X_clipped,y)]).sum(axis=0)
    scale = np.sqrt((lamb*GS**2)/(2*eps))
    np.random.seed(seed)

    noise_scale_vector = scale * np.ones(len(pass_object.monomial_exponents))
    half_noise_index = ((pass_object.monomial_exponents == 1).sum(1) == 2)
    noise_scale_vector[half_noise_index] /= np.sqrt(2)

    perturbed_ss = np.random.normal(loc=approx_ss, scale=noise_scale_vector)
    return len(y), approx_ss[1:], perturbed_ss[1:], (noise_scale_vector**2)[1:]

def generate_data_config(N, d, P, l2_norm, pass_object, perturbed_ss, variances, k=1):
    config = {
        "N": N * k,
        "d": d,
        "P": P,
        "s": 2.5 * l2_norm**2,
        "mon_terms": pass_object.monomial_exponents.shape[0],
        "mult_terms3": pass_object.multinomial_exponents3.shape[0],
        "multinomial_exponents3": pass_object.multinomial_exponents3,
        "multinomial_coefficients3": pass_object.multinomial_coefficients3,

        "t_m": pass_object.t_m,
        "t_m_I": pass_object.t_m_I,
        "t_m_m": pass_object.t_m_m,

        "i_4_terms_m_m": pass_object.i_partitions_4_m_m.shape[0],
        "i_4_terms_m_m_I": pass_object.i_partitions_4_m_m_I.shape[0],
        "i_4_terms_m_mu": pass_object.i_partitions_4_m_mu.shape[0],
        "i_6_terms_m_m_mu": pass_object.i_partitions_6_m_m_mu.shape[0],

        "i_partitions_4_m_m": pass_object.i_partitions_4_m_m,
        "i_partitions_4_m_m_I": pass_object.i_partitions_4_m_m_I,
        "i_partitions_4_m_mu": pass_object.i_partitions_4_m_mu,
        "i_partitions_6_m_m_mu": pass_object.i_partitions_6_m_m_mu,
        "degrees_m": pass_object.degrees_m,
        "degrees_mu3": pass_object.degrees_mu3,
        "pert_ss": perturbed_ss * k,
        "lkj": 2,
        "DP_VAR": variances * k**2
        }
    return config

def privatize_config(config, h, GS, pass_object, lamb=2, base_seed=99):
    perturbed_ss = config["pert_ss"]
    dp_var = config["DP_VAR"]

    add_scale = np.sqrt(0.5 * (lamb*GS**2)*h)
    np.random.seed(base_seed)

    noise_scale_vector = add_scale * np.ones(len(pass_object.monomial_exponents))
    half_noise_index = ((pass_object.monomial_exponents == 1).sum(1) == 2)
    noise_scale_vector[half_noise_index] /= np.sqrt(2)

    new_config = config.copy()
    new_config["pert_ss"] = np.random.normal(loc=perturbed_ss, scale=noise_scale_vector[None,1:])
    new_config["DP_VAR"] = dp_var + noise_scale_vector[None,1:]**2

    return new_config
