# Code for NeurIPS 2023 submission: Exploiting Correlated Auxiliary Feedbacks in Parameterized Bandits
This folder contains code used for the plotting figures in the submitted paper.

## About Code
### Dependencies:
    Python version: 3.9.6
    Packages (more details in requirement.txt file): 
        numpy, pandas, scipy, matplotlib, scikit-learn, and tqdm

### Description of Files:
    1. lin_ucb.py: This file contains code used for generating the plots related Lin-UCB algorithm.
    2. non_lin_ucb.py: This file contains code used for generating the plots related Non-linear version of Lin-UCB algorithm.
    3. oful.py: This file contains code used for generating the plots related OFUL algorithm.

### How to Run?
    Ensures all dependencies met before running the code. The plots will be saved in folder 'plots' and data files will be saved in 'results' folder.

    To generate any figure used in the code, run 'python file_name.py plot_type' where: 
        'file_name' corresponds to the benchmark bandit algorithm used in paper and
        'plot_type' is a command line input used for generating different plots.

    There are following options for plot_type: {compare, correlation, bias, history, fixed_history, is}
        compare - plots regret of different algorithms
        correlation - plots regret for different value of correlation coefficient between reward and auxiliary feedback
        bias - plots regret for using different fixed baises in given estimated
        history - plots regret for different auxiliary function estimator using given history (keep history fixed across rounds)
        is - plots regret for different value of 'r'
        random_history - plots regret for different auxiliary function estimator using given history (randomply change hostory for each round) 

    'compare' is the default option.


    




